/*
//@ FILE_NAME:	   cc_opcodes.h
//@ FACILITY:	   EM486
//@ AUTHORS:	   John Yates
//@ CREATION_DATE: 02 April 1996
//@ MODIFIED_DATE: 02 April 1996
//@ VERSION:	   0.0
//@ COPYRIGHT:	   COPYRIGHT (c) 1996 BY DIGITAL EQUIPMENT CORPORATION,
//@ COPYRIGHT:	   MAYNARD, MASSACHUSETTS.
//@ COPYRIGHT:	   ALL RIGHTS RESERVED.
//#+
//  THIS SOFTWARE IS FURNISHED UNDER A LICENSE AND MAY BE USED AND COPIED
//  ONLY  IN  ACCORDANCE  OF  THE  TERMS  OF  SUCH  LICENSE  AND WITH THE
//  INCLUSION OF THE ABOVE COPYRIGHT NOTICE. THIS SOFTWARE OR  ANY  OTHER
//  COPIES THEREOF MAY NOT BE PROVIDED OR OTHERWISE MADE AVAILABLE TO ANY
//  OTHER PERSON.  NO TITLE TO AND  OWNERSHIP OF THE  SOFTWARE IS  HEREBY
//  TRANSFERRED.
//
//  THE INFORMATION IN THIS SOFTWARE IS	 SUBJECT TO CHANGE WITHOUT NOTICE
//  AND SHOULD	NOT  BE	 CONSTRUED  AS A COMMITMENT BY DIGITAL EQUIPEMENT
//  CORPORATION.
//
//  DIGITAL ASSUMES NO RESPONSIBILITY FOR THE USE  OR  RELIABILITY OF ITS
//  SOFTWARE ON EQUIPMENT WHICH IS NOT SUPPLIED BY DIGITAL.
//#-
*/


/* Byte, word, and long tables must be adjacent and in order */
	CC_DEFINE(dec_b, ALL_BUT_C)
	CC_DEFINE(dec_w, ALL_BUT_C)
	CC_DEFINE(dec_l, ALL_BUT_C)

/* CMP/TEST code expects 3 cmp tables to follow immediately 3 test tables */
/* Byte, word, and long tables must be adjacent and in order */
	CC_DEFINE(LOGOP_b, ALL)
	CC_DEFINE(LOGOP_w, ALL)
	CC_DEFINE(LOGOP_l, ALL)

/* Used by CMP, SUB, and SBB when CF == 0 */
/* Byte, word, and long tables must be adjacent and in order */
	CC_DEFINE(sub_b, ALL)
	CC_DEFINE(sub_w, ALL)
	CC_DEFINE(sub_l, ALL)

/* SBB code expects 3 sbb1 tables to follow immediately 3 sbb0 tables */
/* Byte, word, and long tables must be adjacent and in order */
	CC_DEFINE(sbb1_b, ALL)
	CC_DEFINE(sbb1_w, ALL)
	CC_DEFINE(sbb1_l, ALL)

/* Byte, word, and long tables must be adjacent and in order */
	CC_DEFINE(add_b, ALL)
	CC_DEFINE(add_w, ALL)
	CC_DEFINE(add_l, ALL)

/* ADC code expects 3 sbb1 tables to follow immediately 3 sbb0 tables */
/* Byte, word, and long tables must be adjacent and in order */
	CC_DEFINE(adc1_b, ALL)
	CC_DEFINE(adc1_w, ALL)
	CC_DEFINE(adc1_l, ALL)

/* Byte, word, and long tables must be adjacent and in order */
	CC_DEFINE(inc_b, ALL_BUT_C)
	CC_DEFINE(inc_w, ALL_BUT_C)
	CC_DEFINE(inc_l, ALL_BUT_C)

/* Byte, word, and long tables must be adjacent and in order */
	CC_DEFINE(imul_b, ALL)
	CC_DEFINE(imul_w, ALL)
	CC_DEFINE(imul_l, ALL)

/* Byte, word, and long tables must be adjacent and in order */
	CC_DEFINE(mul_b, ALL)
	CC_DEFINE(mul_w, ALL)
	CC_DEFINE(mul_l, ALL)

	CC_DEFINE(shl, ALL)

	CC_DEFINE(shr, ALL)

	CC_DEFINE(sar, ALL)

	CC_DEFINE(shrd, ALL)

	CC_DEFINE(rxl, ONLY_C_AND_V)

	CC_DEFINE(rxr, ONLY_C_AND_V)

	CC_DEFINE(flags_image, ALL)

	CC_DEFINE(bitop, ALL)

	CC_DEFINE(clc, ONLY_C)

	CC_DEFINE(stc, ONLY_C)

	CC_DEFINE(daa_das, ALL)

	CC_DEFINE(missing_native, ALL)

	CC_DEFINE(missing_xlated, ALL)
