#include <stdio.h>
#include <sys/types.h>
#include <sys/time.h>
#include <sys/resource.h>
#include <unistd.h>
#include <syscall_thunk.h>
#include <errno.h>

int	do_getrusage(int a0, int a1, int a2, int a3, int a4, int a5)
{
    int retval;
    struct x86_rusage * xru = ARG_TO_POINTER(a1);
    struct rusage ru;
    
    retval = getrusage(a0, &ru);
    if(retval < 0) {
	return(-alpha_to_intel_errno(errno));
    }
    else {
	/* Massage return values... */
	xru->ru_utime = ru.ru_utime;
	xru->ru_stime = ru.ru_stime;
	xru->ru_maxrss = ru.ru_maxrss;
	xru->ru_ixrss = ru.ru_ixrss;
	xru->ru_idrss = ru.ru_idrss;
	xru->ru_isrss = ru.ru_isrss;
	xru->ru_minflt = ru.ru_minflt;
	xru->ru_majflt = ru.ru_majflt;
	xru->ru_nswap = ru.ru_nswap;
	xru->ru_inblock = ru.ru_inblock;
	xru->ru_oublock = ru.ru_oublock;
	xru->ru_msgsnd = ru.ru_msgsnd;
	xru->ru_msgrcv = ru.ru_msgrcv;
	xru->ru_nsignals = ru.ru_nsignals;
	xru->ru_nvcsw = ru.ru_nvcsw;
	xru->ru_nivcsw = ru.ru_nivcsw;
	return(retval);
    }
}


