#include <stdio.h>
#include <sys/types.h>
#include <sys/mman.h>
#include <syscall_thunk.h>
#include <errno.h>

extern int	x86_trace_current_syscall;
extern FILE*	x86_logfile;

static bitmask_transtbl	prot_tbl[] = {
	{ X86_PROT_READ, X86_PROT_READ, PROT_READ, PROT_READ },
	{ X86_PROT_WRITE, X86_PROT_WRITE, PROT_WRITE, PROT_WRITE },
	{ X86_PROT_EXEC, X86_PROT_EXEC, PROT_EXEC, PROT_EXEC },
	{ 0, 0, 0, 0 }
};

static bitmask_transtbl flags_tbl[] = {
	{ X86_MAP_SHARED, X86_MAP_SHARED, MAP_SHARED, MAP_SHARED },
	{ X86_MAP_PRIVATE, X86_MAP_PRIVATE, MAP_PRIVATE, MAP_PRIVATE },
	{ X86_MAP_FIXED, X86_MAP_FIXED, MAP_FIXED, MAP_FIXED },
	{ X86_MAP_ANONYMOUS, X86_MAP_ANONYMOUS, MAP_ANONYMOUS, MAP_ANONYMOUS },
	{ X86_MAP_GROWSDOWN, X86_MAP_GROWSDOWN, MAP_GROWSDOWN, MAP_GROWSDOWN },
	{ X86_MAP_DENYWRITE, X86_MAP_DENYWRITE, MAP_DENYWRITE, MAP_DENYWRITE },
	{ X86_MAP_EXECUTABLE, X86_MAP_EXECUTABLE, MAP_EXECUTABLE, MAP_EXECUTABLE },
	{ X86_MAP_LOCKED, X86_MAP_LOCKED, MAP_LOCKED, MAP_LOCKED },
	{ 0, 0, 0, 0 }
};

extern unsigned int x86_to_alpha_bitmask(unsigned int, bitmask_transtbl *);
extern unsigned int alpha_to_x86_bitmask(unsigned int, bitmask_transtbl *);

/* The "old" version of mmap used a memory block to pass args
 * because the old system call paradigm couldn't take more than
 * four arguments...
 */
int	do_old_mmap(int a0, int a1, int a2, int a3, int a4, int a5)
{
    unsigned int *argbuf = ARG_TO_POINTER(a0);
    unsigned int	x86_addr, x86_prot, x86_flags;
    unsigned int	prot = 0;
    unsigned int	flags = 0;
    caddr_t		retval;

    if(x86_trace_current_syscall) {
	fprintf(x86_logfile, "=> mmap(0x%x, %d, 0x%x, 0x%x, %d, %d)\n",
		argbuf[0], argbuf[1], argbuf[2], argbuf[3],
		argbuf[4], argbuf[5]);
	fflush(x86_logfile);
    }

    x86_addr = argbuf[0];
    x86_prot = argbuf[2];
    x86_flags = argbuf[3];

    /* Massage the protection and flag bits */
    prot = x86_to_alpha_bitmask(x86_prot, prot_tbl);
    flags = x86_to_alpha_bitmask(x86_flags, flags_tbl);

    /* Do this to help ensure that we get a return address that'll fit
     * in a 32-bit pointer.  If the user requested "any address at all"
     * (i.e. MAP_FIXED is not set and 0 given as start address), 
     * tell the kernel to start searching at the same place where the
     * Linux/Intel kernel starts: 0x40000000.
     */
    if(((flags & MAP_FIXED) == 0) && (x86_addr == 0)) {
	x86_addr = 0x40000000;
    }

    retval = mmap4k((char *)((unsigned long)x86_addr), argbuf[1], prot, flags, 
					argbuf[4], argbuf[5]);

    if((unsigned long)retval == 0xffffffffffffffff) {
	return(-alpha_to_intel_errno(errno));
    }

    /* If we got a result in hi memory, we can't use it! */
    if((unsigned long)retval & 0xffffffff00000000L) {
	/* Unmap it... */
	(void)munmap(retval, argbuf[1]);
	return(-ENOMEM);
    }

    /* Otherwise, we're okay... */
    return((int)((unsigned long)retval & 0xffffffff));
}

