// Definition of the fx_cpu_c class; this is a C++ encapsulation of
// the 486 emulator with methods that make it interchangeable with
// the BOCHS emulator in the Linux/X86 emulator.

#include <stdio.h>
#include "run486.h"

class fx_cpu_c {
    private:
	EM486_Context *	cxt;		// The guts of the emulated CPU
	int	      * table_space;	// Static tables for the emulator.
	FILE	      * logfile;

    public:
    	fx_cpu_c();			// constructor

	~fx_cpu_c();			// destructor

	void init_cpu();		// Initialize CPU to default state

	void init_cpu(unsigned int eax,	// Initialize CPU to specified state
		 unsigned int ebx,
		 unsigned int ecx,
		 unsigned int edx,
		 unsigned int esi,
		 unsigned int edi,
		 unsigned int ebp,
		 unsigned int esp,
		 unsigned int eip);

	void set_logfile(FILE *);	// Specify log file

	void cpu_loop();		// Run the CPU!

	int registers_homed()		// Test whether we're emulating x86
	{				// code or not...
	    if(cxt) {
		return(cxt->rHOMED);
	    }
	    else {
		return(0);
	    }
	}


	unsigned int	get_EAX();	// Read individual registers
	unsigned int	get_EBX();
	unsigned int	get_ECX();
	unsigned int	get_EDX();
	unsigned int	get_ESI();
	unsigned int	get_EDI();
	unsigned int	get_ESP();
	unsigned int	get_EBP();
	unsigned int	get_EIP();

	void	set_EAX(unsigned int);	// Write individual registers
	void	set_EBX(unsigned int);
	void	set_ECX(unsigned int);
	void	set_EDX(unsigned int);
	void	set_ESI(unsigned int);
	void	set_EDI(unsigned int);
	void	set_EBP(unsigned int);
	void	set_ESP(unsigned int);
	void	set_EIP(unsigned int);
};

